# **_TextMesh Pro User Guide_**

#### **Overview**
This User Guide was designed to provide first time users of TextMesh Pro with a basic overview of the features and functionality of the tool.

#### **Installation**
The TextMesh Pro UPM package is already included with the Unity Editor and as such does not require installation. TextMesh Pro "TMP" does however require adding resources to your project which are essential for using TextMesh Pro. 

To import the "*TMP Essential Resources*", please use the "*Window -> TextMeshPro -> Import TMP Essential Resources*" menu option. These resources will be added at the root of your project in the "*TextMesh Pro*" folder.

The TextMesh Pro package also includes additional resources and examples that will make discovering and learning about TextMesh Pro's powerful features easier. It is strongly recommended that first time users import these additional resources. 

To import the "*TMP Examples & Extras*", please use the "*Window -> TextMeshPro -> Import TMP Examples & Extras*" menu option. These resources will also be added in the same "*TextMesh Pro*" folder inside your project. 


#### **Quick Start**
There are two TextMesh Pro components available. The first TMP text component is of type &lt;TextMeshPro&gt; and designed to work with the MeshRenderer. This component is an ideal replacement for the legacy TextMesh component. 

To add a new &lt;TextMeshPro&gt; text object, go to: *GameObject->3D Object->TextMeshPro Text*. 

The second TMP text component is of type  &lt;TextMeshProUGUI&gt; and designed to work with the CanvasRenderer and Canvas system. This component is an ideal replacement for the UI.Text component. 

To add a new &lt;TextMeshProUGUI&gt; text object, go to: *GameObject->UI->TextMeshPro Text*. 

You may also wish to watch this [Getting Started](https://youtu.be/olnxlo-Wri4) short video which covers this topic.

We strongly recommend that you also watch the [Font Asset Creation](https://youtu.be/qzJNIGCFFtY) video as well as the [Working with Material Presets](https://youtu.be/d2MARbDNeaA) as these two topics is also key to working and getting the most out of TextMesh Pro. 

As mentionned in the Installation section of this guide, it is recommended that you import the "*TMP Examples & Extras*" and take the time to explore each of the examples as they provide a great overview of the functionality of the tool and the many text layout and [rich text tags](http://digitalnativestudios.com/textmeshpro/docs/rich-text/) available in TextMesh Pro.

#### **Support & API Documentation**
Should you have questions or require assistance, please visit the [Unity UI & TextMesh Pro](https://forum.unity.com/forums/unity-ui-textmesh-pro.60/) section of the Unity forum as well as the [TextMesh Pro User Forum](http://digitalnativestudios.com/forum/index.php) where you will find additional information, [Video Tutorials](http://digitalnativestudios.com/forum/index.php?board=4.0) and [FAQ](http://digitalnativestudios.com/forum/index.php?topic=890.0). In the event you are unable to find the information you seek, always feel free to post on the [Unity UI & TextMesh Pro](https://forum.unity.com/forums/unity-ui-textmesh-pro.60/) section user forum.

[Online Documentation](http://digitalnativestudios.com/textmeshpro/docs/) is also available on TextMesh Pro including Rich Text tags, Shaders, Scripting API and more.

